---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：6-Log Output

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標表示/保存時間**：明示的な定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/output/browser/outputServices.ts` - OutputService (行302-630)
- E-02: `src/vs/workbench/contrib/output/browser/outputServices.ts` - OutputChannel (行36-88)
- E-03: `src/vs/workbench/contrib/output/browser/outputServices.ts` - OutputViewFilters (行100-300)
- E-04: `src/vs/workbench/contrib/output/browser/outputServices.ts` - saveOutputAs() (行492-537)
- E-05: `src/vs/workbench/contrib/output/browser/outputServices.ts` - showChannel() (行406-416)
- E-06: `src/vs/workbench/contrib/output/browser/outputServices.ts` - createChannel() (行567-583)
- E-07: `src/vs/workbench/contrib/output/browser/outputServices.ts` - OUTPUT_ACTIVE_CHANNEL_KEY (行34)
- E-08: `src/vs/workbench/services/output/common/output.ts` - IOutputChannel interface
- E-09: `src/vs/workbench/services/output/common/output.ts` - OUTPUT_MIME, LOG_MIME
- E-10: `src/vs/platform/log/common/log.ts` - LogLevel enum

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URIスキームはSchemas.outputChannel | E-02 (行54) | ○ |
| C-02 | MIME TypeにOUTPUT_MIME, LOG_MIME | E-09 | ○ |
| C-03 | LogLevelに0-5の値（Off〜Error） | E-10 | ○ |
| C-04 | OutputViewFiltersで各レベルフィルタ | E-03 | ○ |
| C-05 | trace/debug/info/warning/errorフィルタ | E-03 (行221-274) | ○ |
| C-06 | textフィルタでパターンフィルタリング | E-03 (行137-148) | ○ |
| C-07 | !パターンで除外フィルタ | E-03 (行162-167) | ○ |
| C-08 | カンマ区切りで複数パターン | E-03 (行184-219) | ○ |
| C-09 | 引用符でパターン囲み対応 | E-03 (行193-200) | ○ |
| C-10 | saveOutputAs()でログ保存 | E-04 | ○ |
| C-11 | showSaveDialogでファイル選択 | E-04 (行509-517) | ○ |
| C-12 | textModelService.createModelReference | E-04 (行524) | ○ |
| C-13 | fileService.writeFileで保存 | E-04 (行526) | ○ |
| C-14 | registerCompoundLogChannelで複数チャネル結合 | E-01 (行464-490) | ○ |
| C-15 | showChannel()でチャネル表示 | E-05 | ○ |
| C-16 | OUTPUT_ACTIVE_CHANNEL_KEYでアクティブチャネル保持 | E-07 | ○ |
| C-17 | チャネル未登録でエラー | E-06 (行589-590) | ○ |
| C-18 | DelegatedOutputChannelModelが通常チャネル | E-02 (行66) | ○ |
| C-19 | FileOutputChannelModelがファイルベース | E-02 (行64) | ○ |
| C-20 | MultiFileOutputChannelModelが複数ソース | E-02 (行61) | ○ |
| C-21 | canSetLogLevel()でログレベル変更権限確認 | E-01 (行434-436) | ○ |
| C-22 | telemetryLogIdはログレベル変更不可 | E-01 (行435) | ○ |
| C-23 | getLogEntries()で構造化ログ取得 | E-02 (行69-71) | ○ |
| C-24 | StorageScope.WORKSPACEでアクティブチャネル保持 | E-01 (行339) | ○ |
| C-25 | 目標表示/保存時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（目標表示/保存時間）は実装コードに明示的な定義がない
  - 候補：パフォーマンステスト仕様書 / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ログレベル定義（E-10に基づく）
- 0: 低リスク - フィルタリング機能（E-03に基づく）
- 0: 低リスク - 保存処理（E-04に基づく）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] LogLevelのenum値が最新実装と一致しているか
- [ ] OutputViewFiltersの各フィルタが正しく記載されているか
- [ ] テキストフィルタ構文（!除外、カンマ区切り、引用符）が正しいか
- [ ] saveOutputAs()の処理フローが実装と一致しているか
- [ ] チャネル種別（Delegated/File/MultiFile）が正しいか
